#include <bits/stdc++.h>
using namespace std;
using ll = long long;
const ll INFLL = (1LL<<60);

struct Mast {
    ll x;
    ll h;
    int idx;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;
    vector<Mast> a(n);
    for (int i = 0; i < n; ++i) { cin >> a[i].x; a[i].idx = i; }
    for (int i = 0; i < n; ++i) cin >> a[i].h;

    // Sort by x
    sort(a.begin(), a.end(), [](const Mast& A, const Mast& B){ return A.x < B.x; });

    // Precompute segments (between consecutive sorted masts)
    int m = max(0, n-1);
    vector<ll> L0, R0; L0.reserve(m); R0.reserve(m);
    for (int i = 0; i + 1 < n; ++i) {
        ll xi = a[i].x, xj = a[i+1].x;
        ll hi = a[i].h, hj = a[i+1].h;
        // c = (xi + xj + hj - hi) / 2  (integer by problem guarantee)
        ll c = (xi + xj + hj - hi) / 2;
        ll H = hi + llabs(xi - c);
        ll L = c - H;
        ll R = c + H;
        L0.push_back(L);
        R0.push_back(R);
    }

    // Build sorted L array with corresponding R and prefix maxR
    int segs = (int)L0.size();
    vector<pair<ll,ll>> LR(segs);
    for (int i = 0; i < segs; ++i) LR[i] = {L0[i], R0[i]};
    sort(LR.begin(), LR.end()); // sort by L0
    vector<ll> L_sorted(segs), prefixMaxR(segs);
    for (int i = 0; i < segs; ++i) {
        L_sorted[i] = LR[i].first;
        prefixMaxR[i] = LR[i].second;
        if (i) prefixMaxR[i] = max(prefixMaxR[i], prefixMaxR[i-1]);
    }
    // also sorted R array
    vector<ll> R_sorted(segs);
    for (int i = 0; i < segs; ++i) R_sorted[i] = R0[i];
    sort(R_sorted.begin(), R_sorted.end());

    // Prepare answer array; mark those needing mast-top check
    const ll INF = (ll)4e18;
    vector<long double> answer(n, -1.0L); // store final distances, -1 means none
    vector<int> need_mast_check; need_mast_check.reserve(n);

    for (int i = 0; i < n; ++i) {
        ll xi = a[i].x, hi = a[i].h;
        ll A = xi - hi;
        ll B = xi + hi;

        bool inside = false;
        if (segs > 0) {
            // find last index with L0 <= A
            int pos = int(upper_bound(L_sorted.begin(), L_sorted.end(), A) - L_sorted.begin()) - 1;
            if (pos >= 0) {
                if (prefixMaxR[pos] >= B) inside = true;
            }
        }
        if (inside) {
            answer[a[i].idx] = 0.0L;
            continue;
        }

        // compute nearest interval to right: first L0 > A
        long double best = (long double)INF;
        if (segs > 0) {
            int posR = int(upper_bound(L_sorted.begin(), L_sorted.end(), A) - L_sorted.begin());
            if (posR < segs) {
                ll Lcand = L_sorted[posR];
                long double d = (long double)(Lcand + hi - xi);
                if (d < best) best = d;
            }
            // nearest interval to left: last R0 < B
            int posL = int(lower_bound(R_sorted.begin(), R_sorted.end(), B) - R_sorted.begin()) - 1;
            if (posL >= 0) {
                ll Rcand = R_sorted[posL];
                long double d = (long double)(xi - Rcand + hi);
                if (d < best) best = d;
            }
        }

        if (best < (long double)INF/4) {
            answer[a[i].idx] = best;
        } else {
            // no segment covers any point >= hi: need to check mast tops with h_j >= hi
            answer[a[i].idx] = -2.0L; // mark for mast-check
            need_mast_check.push_back(i); // index in sorted-by-x array
        }
    }

    // If any need mast-check, process queries offline by descending hi
    if (!need_mast_check.empty()) {
        // Build list of queries: pair (hi, index in sorted array)
        vector<pair<ll,int>> queries;
        queries.reserve(need_mast_check.size());
        for (int idx : need_mast_check) queries.emplace_back(a[idx].h, idx);
        sort(queries.begin(), queries.end(), greater<>()); // descending hi

        // Build list of masts to insert: sort all masts by h desc
        vector<pair<ll,int>> allByH; allByH.reserve(n);
        for (int i = 0; i < n; ++i) allByH.emplace_back(a[i].h, i);
        sort(allByH.begin(), allByH.end(), greater<>());

        // set of x positions inserted (those with h >= current_hi)
        std::set<ll> Sx;
        unordered_map<ll,ll> x2h; x2h.reserve(n*2);
        int ptr = 0;
        for (auto &q : queries) {
            ll need_h = q.first;
            int idxSorted = q.second;
            // insert all masts with height >= need_h
            while (ptr < n && allByH[ptr].first >= need_h) {
                int id = allByH[ptr].second;
                ll xx = a[id].x;
                ll hh = a[id].h;
                Sx.insert(xx);
                x2h[xx] = hh;
                ++ptr;
            }
            // now find nearest in Sx to a[idxSorted].x
            if (Sx.empty()) {
                answer[a[idxSorted].idx] = -1.0L;
            } else {
                ll xi = a[idxSorted].x;
                long double bestd = (long double)INF;
                auto it = Sx.lower_bound(xi);
                if (it != Sx.end()) {
                    ll xj = *it; ll hj = x2h[xj];
                    long double dx = (long double) (xj - xi);
                    long double dy = (long double) (hj - a[idxSorted].h);
                    long double d = sqrtl(dx*dx + dy*dy);
                    if (d < bestd) bestd = d;
                }
                if (it != Sx.begin()) {
                    auto it2 = it; --it2;
                    ll xj = *it2; ll hj = x2h[xj];
                    long double dx = (long double) (xj - xi);
                    long double dy = (long double) (hj - a[idxSorted].h);
                    long double d = sqrtl(dx*dx + dy*dy);
                    if (d < bestd) bestd = d;
                }
                if (bestd >= (long double)INF/4) answer[a[idxSorted].idx] = -1.0L;
                else answer[a[idxSorted].idx] = bestd;
            }
        }
    }

    // Print answers in original input order:
    // Problem statement examples print integers; but distances are geometric.
    // We'll print:
    //  - "-1" if no such point
    //  - otherwise print distance as integer if it is integral (within small eps), else print with 10 decimals.
    cout.setf(std::ios::fixed); cout<<setprecision(10);
    for (int i = 0; i < n; ++i) {
        long double v = answer[i];
        if (v < -1e9L) { // should not happen
            cout << "-1\n";
        } else if (v < -0.5L) { // marked -1
            cout << "-1\n";
        } else {
            // If nearly integer, print as integer (no decimals)
            long double roundv = llround(v);
            if (fabsl(v - roundv) <= 1e-9L) {
                cout << (long long) roundv << "\n";
            } else {
                cout << v << "\n";
            }
        }
    }

    return 0;
}